'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

' MMBasic program to convert UTFT fonts to the Micromite DefineFont format.

' This can be run on a Maximite, Micromite+ or the DOS version of MMBasic.

'

' It is designed to convert UTFT fonts downloaded from:

'     http://www.rinkydinkelectronics.com/r_fonts.php

'     Thanks to Henning Karlsen for UTFT fonts and making them available.

'

' When prompted you must supply the file name WITHOUT the extension.

' this will look for the file with .c extension and generate the

' Micromite font file with a .bas extension

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''



Input "File name (without an extension which must be .c): ", f$



Open f$ + ".c" For input As #1

Open f$ + ".bas" For output As #2



Line Input #1, s$

If Left$(s$, 2) <> "//" Or Right$(s$, 2) <> ".c" Then GoTo StartConvert

Print #2, "'" Mid$(s$, 3, Len(s$) - 4) ".bas"

nbr = Len("'" + Mid$(s$, 3, Len(s$) - 4) + ".bas")



Line Input #1, s$

If Left$(s$, 2) <> "//" Then GoTo StartConvert

Print #2, "'" Mid$(s$, 3)

nbr = nbr + Len(s$)



Line Input #1, s$

If Left$(s$, 2) <> "//" Then GoTo StartConvert

Print #2, "'" Mid$(s$, 3)

nbr = nbr + Len(s$)



Line Input #1, s$

If Left$(s$, 2) <> "//" Then GoTo StartConvert

Print #2, "'" Mid$(s$, 3)

nbr = nbr + Len(s$)



StartConvert:

Print #2, "DefineFont #8";

nbr = nbr + 11

lc = 0



Do

    If lc Mod 8 = 0 Then Print #2 : Print #2, "  "; : nbr = nbr + 3

    a$ = GetHex$()

    b$ = GetHex$()

    c$ = GetHex$()

    d$ = GetHex$()

    Print #2, d$ c$ b$ a$ " ";

    lc = lc + 1

    nbr = nbr + 9

Loop





Function GetHex$()

    Do

        Do

            If Eof(#1) Then

                Print #2 : Print #2, "End DefineFont"

                Close #1, #2

                Print "Font converted.  Size:" Int((nbr + 16) / 1024) "KB"

                End

            EndIf

            s$ = Input$(1, 1)

        Loop While s$ <> "0"

        s$ = Input$(1, 1)

    Loop While s$ <> "x"

    GetHex$ = Input$(2, #1)

End Function

